/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.EthernetConfigurePanel;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.simulation.NetworkSimulationManager;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConfiguration
implements Serializable,
Storable {
    private static final long serialVersionUID = 1L;
    private Vector<EthernetConnection> fEthernetConnections;
    private String fIPAddress;
    private String fSubnetMask;
    private String fGateWay;
    private Hardware fHardware;
    private transient boolean fDBErrorDisplayed;
    private transient boolean fIOBlockErrorDisplayed;

    public NetworkConfiguration() {
        this.fEthernetConnections = new Vector();
        this.fIPAddress = "";
        this.fSubnetMask = "";
        this.fGateWay = "";
    }

    public NetworkConfiguration(Hardware hw) {
        this.fHardware = hw;
        this.fEthernetConnections = new Vector();
        this.fIPAddress = "";
        this.fSubnetMask = "";
        this.fGateWay = "";
    }

    public Hardware getHardware() {
        return this.fHardware;
    }

    public void setHardware(Hardware hardware) {
        this.fHardware = hardware;
    }

    public Vector<EthernetConnection> getEthernetConnections() {
        return this.fEthernetConnections;
    }

    public void setEthernetConnections(Vector newVector) {
        this.fEthernetConnections = newVector;
    }

    public String getIPAddress() {
        if (this.fIPAddress == null) {
            this.fIPAddress = "";
        }
        return this.fIPAddress;
    }

    public void setIPAddress(String ethernetAddress) {
        this.fIPAddress = ethernetAddress;
    }

    public String getGateWay() {
        if (this.fGateWay == null) {
            this.fGateWay = "";
        }
        return this.fGateWay;
    }

    public void setGateWay(String gateWay) {
        this.fGateWay = gateWay;
    }

    public String getSubnetMask() {
        if (this.fSubnetMask == null) {
            this.fSubnetMask = "";
        }
        return this.fSubnetMask;
    }

    public void setSubnetMask(String subnetMask) {
        this.fSubnetMask = subnetMask;
    }

    public void executeTransfer(Interpreter interpreter) {
        SimulationManager targetSimulationManager = NetworkSimulationManager.getInstance().getSimulationManager(this.getIPAddress());
        if (this.getIPAddress().equals("") || targetSimulationManager == null || targetSimulationManager.getWiringDiagram() != interpreter.getLogoDrawing().getWiringDiagram()) {
            return;
        }
        for (EthernetConnection localCon : this.getEthernetConnections()) {
            if (!localCon.isClient() || localCon.getLocalTsap().equals("19.FF") || (targetSimulationManager = NetworkSimulationManager.getInstance().getSimulationManager(localCon.getRemoteIP())) == null || !this.isCommunicateChannelAvailable(localCon, targetSimulationManager)) continue;
            Interpreter targetInterpreter = targetSimulationManager.getInterpreter();
            boolean isNToConstant = localCon.getLocalTsap() == "19.00";
            Enumeration<EthernetConnection.Transfer> transfers = localCon.getVMWriteTransactions().elements();
            this.executeDataTransfer(1, transfers, interpreter, targetInterpreter, isNToConstant);
            transfers = localCon.getVMReadTransactions().elements();
            this.executeDataTransfer(0, transfers, interpreter, targetInterpreter, isNToConstant);
        }
    }

    private boolean isCommunicateChannelAvailable(EthernetConnection localCon, SimulationManager targetSimulationManager) {
        for (EthernetConnection remoteCon : targetSimulationManager.getWiringDiagram().getNetworkInfo().getEthernetConnections()) {
            String acceptedIP;
            if (remoteCon.isClient() || !(acceptedIP = remoteCon.getAcceptedIP()).equals("") && !acceptedIP.equals(this.getIPAddress()) || !localCon.getRemoteTsap().equals(remoteCon.getLocalTsap()) || !localCon.getLocalTsap().equals(remoteCon.getRemoteTsap())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.fGateWay.equals("") && this.fIPAddress.equals("") && this.fSubnetMask.equals("") && this.fEthernetConnections.size() == 0;
    }

    public int getFreeConnectionID() {
        return EthernetConfigurePanel.getFreeConnectionID(this.fEthernetConnections, this.fHardware.getIntProperty("maximumConnections"));
    }

    public String getFreeLocalTsap() {
        return EthernetConfigurePanel.getFreeLocalTsap(this.fEthernetConnections);
    }

    private int getVMAddress(int dataType, int address, Hardware hw) {
        int startAddress = dataType == 2 ? hw.getIntProperty("iStartAddress") + address : (dataType == 3 ? hw.getIntProperty("qStartAddress") + address : (dataType == 4 ? hw.getIntProperty("mStartAddress") + address : address));
        return startAddress;
    }

    private void executeDataTransfer(int op, Enumeration<EthernetConnection.Transfer> transfers, Interpreter interpreter, Interpreter targetInterpreter, boolean isNToConstrant) {
        while (transfers.hasMoreElements()) {
            EthernetConnection.Transfer transfer = transfers.nextElement();
            if (transfer.fRemoteDataBlockType == 1) {
                if (this.fDBErrorDisplayed) continue;
                Log.print(Language.getString("ethernet.dbNotSupported", "The simulation for the datatransfer with data type DBx.DBBx is not supported."));
                this.fDBErrorDisplayed = true;
                continue;
            }
            if (op == 0 && transfer.fLocalDataBlockType != 0 || op == 1 && transfer.fRemoteDataBlockType != 0) {
                if (this.fIOBlockErrorDisplayed) continue;
                Log.print(Language.getString("ethernet.iqmCannotBeWritten", "IB, QB, MB can't be written."));
                this.fIOBlockErrorDisplayed = true;
                continue;
            }
            int localAddress = this.getVMAddress(transfer.fLocalDataBlockType, transfer.fLocalAddress, interpreter.fWiringDiagram.getHardware());
            int remoteAddress = this.getVMAddress(transfer.fRemoteDataBlockType, transfer.fRemoteAddress, targetInterpreter.fWiringDiagram.getHardware());
            for (int i = 0; i < transfer.fLength; ++i) {
                if (op == 0) {
                    interpreter.writeVM(1, localAddress + i, targetInterpreter.readVM(1, remoteAddress + i));
                    continue;
                }
                targetInterpreter.writeVM(1, remoteAddress + i, interpreter.readVM(1, localAddress + i));
            }
        }
    }

    public boolean compareTo(NetworkConfiguration other, DifferenceTableModel differences) {
        boolean diff = true;
        StringBuffer diffStr1 = new StringBuffer("");
        StringBuffer diffStr2 = new StringBuffer("");
        StringBuffer diffStr3 = new StringBuffer("");
        if (!Util.isObjectEqual(this.fIPAddress, other.getIPAddress())) {
            diffStr1.append(Language.getString("ethernet.ethernetConfigurePanel.addressPanel", "Module Address"));
            diffStr1.append(":\n");
            diffStr1.append("    ");
            diffStr1.append(Language.getString("ethernet.ethernetConfigurePanel.ipAddressPanel", "IP Address"));
            diffStr2.append("\n");
            diffStr2.append(this.fIPAddress);
            diffStr3.append("\n");
            diffStr3.append(other.getIPAddress());
            diff = false;
        }
        if (!Util.isObjectEqual(this.fSubnetMask, other.getSubnetMask())) {
            if (diff) {
                diffStr1.append(Language.getString("ethernet.ethernetConfigurePanel.addressPanel", "Module Address"));
                diffStr1.append(":\n");
            } else {
                diffStr1.append("\n");
                diffStr2.append("\n");
                diffStr3.append("\n");
            }
            diffStr1.append("    ");
            diffStr1.append(Language.getString("ethernet.tcpSettingPanel.columnSubnetmask", "Subnet Mask"));
            diffStr2.append(this.fSubnetMask);
            diffStr3.append(other.getSubnetMask());
            diff = false;
        }
        if (!Util.isObjectEqual(this.fGateWay, other.getGateWay())) {
            if (diff) {
                diffStr1.append(Language.getString("ethernet.ethernetConfigurePanel.addressPanel", "Module Address"));
                diffStr1.append(":\n");
            } else {
                diffStr1.append("\n");
                diffStr2.append("\n");
                diffStr3.append("\n");
            }
            diffStr1.append("    ");
            diffStr1.append(Language.getString("ethernet.tcpSettingPanel.columnGateway", "Gateway"));
            diffStr2.append(this.fGateWay);
            diffStr3.append(other.getGateWay());
            diff = false;
        }
        if (!diff) {
            differences.add(diffStr1.toString(), diffStr2.toString(), diffStr3.toString());
        }
        String ethernetStr = Language.getString("extra.ethernet.connections", "Ethernet Connections");
        String notFoundStr = Language.getString("compare.notFound", "Not found");
        for (int i = 0; i < this.getEthernetConnections().size(); ++i) {
            EthernetConnection conn = this.getEthernetConnections().get(i);
            EthernetConnection otherConn = this.indexOf(other.getEthernetConnections(), conn.getID());
            if (otherConn == null) {
                differences.add(ethernetStr + " - " + Language.getString("dialog.options.color.connection", "Connection") + conn.getID(), "", notFoundStr);
                diff = false;
                continue;
            }
            if (conn.compareTo(other.getEthernetConnections().get(i), differences)) continue;
            diff = false;
        }
        for (int j = 0; j < other.getEthernetConnections().size(); ++j) {
            EthernetConnection otherConn = other.getEthernetConnections().get(j);
            EthernetConnection conn = this.indexOf(this.getEthernetConnections(), otherConn.getID());
            if (conn != null) continue;
            differences.add(ethernetStr + " - " + Language.getString("dialog.options.color.connection", "Connection") + otherConn.getID(), notFoundStr, "");
            diff = false;
        }
        return diff;
    }

    private EthernetConnection indexOf(Vector<EthernetConnection> conns, int id) {
        EthernetConnection conn = null;
        for (EthernetConnection each : conns) {
            if (id != each.getID()) continue;
            return each;
        }
        return conn;
    }

    public NetworkConfiguration deepCopy(Hardware hw) {
        NetworkConfiguration config = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(200);
            StorableOutput so = new StorableOutput(outputStream);
            so.writeStorable(this);
            so.close();
            byte[] clipboard = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboard);
            StorableInput si = new StorableInput(inputStream);
            config = (NetworkConfiguration)si.readStorable();
            config.setHardware(hw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        int connCnt = dr.readInt();
        if (connCnt > 0) {
            this.fEthernetConnections = new Vector(connCnt);
            for (int i = 0; i < connCnt; ++i) {
                this.fEthernetConnections.add((EthernetConnection)dr.readStorable());
            }
        }
        this.fIPAddress = dr.readString();
        this.fSubnetMask = dr.readString();
        this.fGateWay = dr.readString();
    }

    @Override
    public void write(StorableOutput dw) {
        if (this.fEthernetConnections != null) {
            dw.writeInt(this.fEthernetConnections.size());
            for (EthernetConnection each : this.fEthernetConnections) {
                dw.writeStorable(each);
            }
        } else {
            dw.writeInt(0);
        }
        dw.writeString(this.fIPAddress);
        dw.writeString(this.fSubnetMask);
        dw.writeString(this.fGateWay);
    }
}

